class PredictiveSearch extends HTMLElement{constructor(){super(),this.selectors={searchQuery:"[data-query]",searchMessage:"[data-message]",input:"[data-search-input]",submit:'button[type="submit"]',loading:"[data-spinner]",clear:"[data-clear-search]",popularSearchItems:["[data-ps-item]"],moreResultIcon:"[data-more-result-icon]"},this.container=document.querySelector("[data-search-popup]"),this.domNodes=queryDomNodes(this.selectors,this.container),this.cachedResults={},this.transitionDuration=300,this.input=this.querySelector('input[type="search"]'),this.predictiveSearchResults=this.querySelector("[data-predictive-search]"),this.searchPopupSearults=this.querySelector(".m-search-popup__result"),this.popularSearches=this.querySelector("[data-popular-searches]"),this.searchCount=this.querySelector("[data-search-count]"),this.setupEventListeners()}setPopularSearchesLink=()=>{const{popularSearchItems}=this.domNodes;popularSearchItems.forEach(itm=>itm.href=createSearchLink(itm.dataset.psQuery))};setupEventListeners(){const{clear}=this.domNodes;this.querySelector("form.m-search-form").addEventListener("submit",this.onFormSubmit.bind(this)),this.input.addEventListener("input",debounce(event=>{this.onChange(event)},300).bind(this)),clear.addEventListener("click",this.onClearSearch.bind(this)),MinimogEvents.subscribe(MinimogTheme.pubSubEvents.closeSearchPopup,()=>this.close(!0))}getQuery(){return this.input.value.trim()}onChange(){const searchTerm=this.getQuery();if(!searchTerm.length){this.close(!0);return}this.getSearchResults(searchTerm)}onFormSubmit(event){(!this.getQuery().length||this.querySelector('[aria-selected="true"] a'))&&event.preventDefault()}onClearSearch(event){event.preventDefault(),this.input.value="",this.onChange()}getSearchResults(searchTerm){const queryKey=searchTerm.replace(" ","-").toLowerCase();this.toggleSpinnerLoading(!0),this.toggleClearSearch(!1);const searchByTag=this.dataset.searchByTag==="true",searchByBody=this.dataset.searchByBody==="true",unavailableProductsOption=this.dataset.unavailableProductsOption;let searchFields="title,product_type,vendor,variants.sku,variants.title";if(searchByTag&&(searchFields+=",body"),searchByBody&&(searchFields+=",tag"),this.cachedResults[queryKey]){this.renderSearchResults(this.cachedResults[queryKey]);return}let searchURL=`${window.MinimogSettings.routes.predictive_search_url}?q=${encodeURIComponent(searchTerm)}&resources[options][unavailable_products]=${unavailableProductsOption}&resources[options][fields]=${searchFields}&section_id=predictive-search`;fetch(`${searchURL}`).then(response=>{if(!response.ok){var error=new Error(response.status);throw this.close(),error}return response.text()}).then(text=>{const resultsMarkup=new DOMParser().parseFromString(text,"text/html").querySelector("#shopify-section-predictive-search").innerHTML;this.cachedResults[queryKey]=resultsMarkup,this.renderSearchResults(resultsMarkup)}).catch(error=>{throw this.close(),error})}renderSearchResults(resultsMarkup){this.predictiveSearchResults.innerHTML=resultsMarkup,this.setAttribute("results",!0),this.querySelector("[data-search-items-wrapper]").childElementCount>0?this.renderSearchQueryAndMessage(!0):this.renderSearchQueryAndMessage(!1),this.toggleSpinnerLoading(!1),this.toggleClearSearch(!0),this.open()}renderSearchQueryAndMessage(results){const{input,searchQuery,searchMessage,moreResultIcon}=this.domNodes,query=input.value,{resultsTitle}=searchMessage.dataset;searchQuery.textContent=query,this.predictiveSearchResults.classList.remove("m:hidden"),this.searchPopupSearults.classList.remove("m:hidden"),results?(searchMessage.textContent=resultsTitle,moreResultIcon.classList.add("m:hidden")):(searchMessage.textContent=searchMessage.dataset.resultsTitle,moreResultIcon.classList.remove("m:hidden"))}toggleSpinnerLoading(show){const{loading,submit}=this.domNodes;submit.style.visibility=show?"hidden":"visible",loading.style.visibility=show?"visible":"hidden"}toggleClearSearch(show){const{clear}=this.domNodes;clear.style.visibility=show?"visible":"hidden"}open(){this.searchPopupSearults.style.setProperty("--search-result-max-height",`${this.resultsMaxHeight||this.getResultsMaxHeight()}px`),this.setAttribute("open",!0),this.input.setAttribute("aria-expanded",!0),this.isOpen=!0,this.popularSearches&&this.popularSearches.classList.add("m:hidden"),this.searchCount.classList.remove("m:hidden")}close(clearSearchTerm=!1){clearSearchTerm&&(this.input.value="",this.removeAttribute("results"),this.toggleClearSearch(!1),this.resultsMaxHeight=!1),this.removeAttribute("open"),this.predictiveSearchResults.classList.add("m:hidden"),this.searchPopupSearults.classList.add("m:hidden"),this.popularSearches&&this.popularSearches.classList.remove("m:hidden"),this.searchCount.classList.add("m:hidden")}getResultsMaxHeight(){return this.resultsMaxHeight=window.innerHeight-document.querySelector("predictive-search").getBoundingClientRect().bottom,this.resultsMaxHeight}}customElements.define("predictive-search",PredictiveSearch);
//# sourceMappingURL=/cdn/shop/t/47/assets/predictive-search.js.map?v=32533127051811055531745492892
